/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class WarModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player = context.getPlayerAttacker();
        if (player == null) {
            return;
        }
        LivingEntity target = context.getLivingTarget();
        if (target == null) {
            return;
        }
        Level world = player.m_20193_();
        if (damageDealt > 0.0f && !world.f_46443_ && RANDOM.nextFloat() <= 0.3f * (float)modifier.getLevel()) {
            world.m_46511_((Entity)target, target.m_20185_(), target.m_20186_(), target.m_20189_(), damageDealt / 10.0f + 1.0f, Explosion.BlockInteraction.NONE);
            AreaEffectCloud cloud = new AreaEffectCloud(world, target.m_20185_(), target.m_20186_(), target.m_20189_());
            cloud.m_19724_((ParticleOptions)ParticleTypes.f_123762_);
            cloud.m_19712_(damageDealt / 10.0f);
            cloud.m_19734_(40);
            cloud.m_19716_(new MobEffectInstance(MobEffects.f_19615_, modifier.getLevel() - 1, 10));
        }
        if (context.isCritical()) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        float damageDealt;
        if (target != null && attacker != null && projectile instanceof AbstractArrow && (damageDealt = (float)((double)((float)(arrow = (AbstractArrow)projectile).m_36789_()) * arrow.m_20184_().m_82553_())) > 0.0f && !attacker.m_9236_().f_46443_ && target.m_6084_() && RANDOM.nextFloat() <= 0.3f * (float)modifier.getLevel()) {
            target.f_19802_ = 0;
            target.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), damageDealt);
            Random random = (Random)target.f_19853_.f_46441_;
        }
        return false;
    }
}

